#!/usr/bin/env perl
#use strict;
#use warnings;

use vars qw(%ENV);

my $debug = 0;
$debug = 1 if $ARGV[0] and $ARGV[0] eq '-d';

$ENV{LESSOPEN} = "|./lesspipe.sh %s";
open F, "TESTCMDS" or die "Could not read TESTCMDS:$!\n";
my $retcode = 0;
while (<F>) {
  next if /^#/;
  next if /^\s*$/;
  chomp;
  my $ignore = $_ =~ s/#\s*ignore error*//;
  my $res = `$_ 2>&1`;
  my $ok = 0;
  if ( $res and $res =~ /command not found: (\S+)/m ) {  # zsh style
    print "result:$res" if $debug;
    $res = "NOT found: $1";
    $ok = 1;
  } elsif ( $res and $res =~ /(\S+):\s+command not found/m ) { # bash style
    print "result:$res" if $debug;
    $res = "NOT found: $1";
    $ok = 1;
  } elsif ( $res and $res =~ /(\S+):\s+not found/m ) { # ksh style
    print "result:$res" if $debug;
    $res = "NOT found: $1";
    $ok = 1;
  } elsif ( $res and $res =~ /no such file or directory: .*?([^\/]+)\b$/m ) {
    print "result:$res" if $debug;
    $res = "NOT found: $1";
    $ok = 1;
  } elsif ( $res ) {
    print "result:$res" if $debug;
    my @res = split /\n/, $res;
    shift @res if $res[0] =~ /^==>/;
    shift @res while @res and $res[0] =~ /^\s*$/;
    $ok = $res[0] =~ /^\s*(\e\[36m)?test(\e\[0m)?\s*$/ if $res[0];
    # special case for nroff
    $ok = $res[0] =~ s/^test \(1\)\s+.*/test/ if $res[0] and ! $ok;
    # special case for perl storable
    $ok = $res[0] =~ s/^\$VAR1 = \\'test';$/test/ if $res[0] and ! $ok;
    $res = $res[0] if $res[0];
  }
  if ( $ok ) {
    $res =~ s/test/ok/ if $ok;
    $res =~ s/^\s+// if $ok;
  } else {
    $retcode++ if ! $ok and ! $ignore;
    $res = "NOT ok";
    $res .= " (ignored)" if $ignore;
  }
  printf "%-55s %s\n", $_, $res;
}
close F;
exit $retcode;
